# Code for finding the first-best optimal social interactions 
# with data and estimates from schools of size between 4 and 50

# Import packages
import os, sys
import numpy as np
import pandas as pd
import pickle, math
import random 
import scipy.optimize
from scipy.optimize import NonlinearConstraint

# Define a function that transforms a NxN matrix into a Nx(N-1) vector 
def matflat_rwise(A):
    a=A.flatten()
    N=A.shape[0]
    b=np.zeros(1)
    for n in range(1,N+1):
        if n==1:
            b=np.concatenate((b,A[n-1,n:N]))
        elif n==N:
            b=np.concatenate((b,A[n-1,0:n-1]))
        else:
            b=np.concatenate((b,A[n-1,0:n-1],A[n-1,n:N]))
    M=b.shape[0]               
    return b[1:M] 

# Define a function that transfrom N*(N-1) by 1 vector into a N by N matrix (with zeros in diagonal)
def vecmat_rwise(x,N):
    A=np.zeros((N,N))
    for n in range(1,N+1):
        if n==1:
            A[n-1,0:N]=np.concatenate((np.zeros(1),x[(N-1)*(n-1):(N-1)*n]))
        elif n==N:
            A[n-1,0:N]=np.concatenate((x[(N-1)*(n-1):(N-1)*n],np.zeros(1)))
        else:
            A[n-1,0:N]=np.concatenate((x[(N-1)*(n-1):(N-1)*(n-1)+n-1],np.zeros(1),x[(N-1)*(n-1)+n-1:(N-1)*n]))   
    return A
   
# Define a function that calculates social capital
def augsc(s,Nh,alpha,Nr):
    M=s.shape[0]
    return s-np.ones((M))-(alpha/Nr)*np.matmul(Nh,s)

# Define a total welfare objective function
def t_welfare(x,DIJ,Thetaij,th):
    beta=th[1:23]
    alpha=th[23:24]
    c=abs(th[24:25])
    beta0=th[0:1]
    N=DIJ.shape[0]
    nij=vecmat_rwise(x[0:N*(N-1)],N) 
    s=x[N*(N-1):N*(N-1)+N] 
    Q=-np.sum(np.sum( (( (np.ones((N,N))-np.identity(N))*beta0+Thetaij )*nij -nij*nij/2)*np.outer(np.ones((N,1)),s)-c*nij*DIJ ,axis=0))/(N*N)
    return Q

if __name__ == '__main__':

    # Load the data
    with open('spatial_interaction_finaldata_schools4to50.pkl','rb') as f:
        Data=pickle.load(f)
    with open('Xdata_pair_level_Schools4to50.pkl','rb') as f:
        xdata=pickle.load(f)
    with open('II_Results_Schools4to50.pkl','rb') as f:
        Result=pickle.load(f)
    th=Result[0]
    beta=th[1:23]
    alpha=th[23:24]
    c=abs(th[24:25])
    beta0=th[0:1]
    sig=th[25:26] 
    Scell=Data[0]
    SDcell=Data[1]
    Xcell1=Data[2]
    Xcell2=Data[3]
    D=Data[4]
    EPcell=Data[5]
    st_list=Data[6]
    GE=Data[7]
    ADcell=Data[9]
    H=len(Scell) 
    Xcell=[] 
    k1=Xcell1[0].shape[2] 
    for h in range(1,H+1):
        Xcell.append(abs(Xcell1[h-1]))
    R=100 
    K=k1*2 
    XBc=[]
    for h in range(1,H+1):
        DIJ=D[h-1]
        N=DIJ.shape[0]
        Xarray1=np.zeros((N,N,K))
        Xarray2=np.zeros((N,N,K))
        X1=Xcell1[h-1]
        X2=Xcell2[h-1]
        for k in range(1,k1+1):
            Xarray1[:,:,k-1]=X1[:,:,k-1]*beta[k-1]
            Xarray2[:,:,k-1]=X2[:,:,k-1]*beta[k1+k-1]
        XBc.append(np.sum(Xarray1,axis=2)+np.sum(Xarray2,axis=2)+(np.ones((N,N))-np.identity(N))*beta0)

    # List that will store results
    Nstats_obs=np.zeros((H,R))
    Sstats_obs=np.zeros((H,R))
    Sstats_opt=np.zeros((H,R))
    Nstats_opt=np.zeros((H,R))
    N0=[]
    NIJ=[]
    NIJ1=[]
    S0=[]
    S1=[]
    S2=[]

    # Start finding the first-best social interactions and social capital (100 simulations)
    for r in range(1,100+1):
        N0r=[]
        NIJr=[]
        NIJ1r=[]
        S0r=[]
        S1r=[]
        S2r=[]
        for h in range(1,H+1):
            np.random.seed(1000*r+h) 
            DIJ=D[h-1]
            N=DIJ.shape[0]
            ERR=sig*np.random.standard_normal((N,N))
            Thetaij=XBc[h-1]+ERR-(np.ones((N,N))-np.identity(N))*beta0
            XBij=XBc[h-1] 
            A=SDcell[h-1]
            F=ADcell[h-1] 
            sres00=scipy.optimize.least_squares(augsc,1.1*np.ones(N),args=(A*F,alpha,N),bounds=(np.ones(N),10*np.ones(N)))
            DI=np.identity(N)-(alpha/N)*(Thetaij+(np.ones((N,N))-np.identity(N))*beta0) ##/N (divide by N?)
            s_star=np.matmul(np.matmul(np.linalg.inv(DI),(np.identity(N)-alpha*c*DIJ)),np.ones((N,1)))
            Nhat=np.zeros((N,N))
            for n in range(1,N+1):
                for m in range(1,N+1):
                    if n==m:
                        Nhat[n-1,m-1]=0
                    else:
                        Nhat[n-1,m-1]=XBij[n-1,m-1]-c*DIJ[n-1,m-1]/s_star[m-1]+ERR[n-1,m-1]
            nz=1*(Nhat>0) 
            Nhat0=Nhat*nz # ensure nonnegative social interactions
            sres0=scipy.optimize.least_squares(augsc,1.1*np.ones(N),args=(Nhat0,alpha,N),bounds=(np.ones(N),10*np.ones(N)))
            # Solve the social planner problem
            x0=np.concatenate((matflat_rwise(Nhat0),sres0.x)) # initial point
            xlb=np.concatenate((np.zeros(N*(N-1)),np.ones(N)))
            xub=100*np.ones(N*(N-1)+N)
            bnds=np.zeros((xlb.shape[0],2))
            bnds[:,0]=xlb
            bnds[:,1]=xub
            clb=np.zeros(N)
            cub=np.ones(N)*np.inf
            cons1 = ({'type': 'eq', 'fun': lambda x: np.ones(N)+(alpha/N)*np.matmul(vecmat_rwise(x[0:N*(N-1)],N),x[N*(N-1):N*(N-1)+N])-x[N*(N-1):N*(N-1)+N]  })
            eff0=scipy.optimize.minimize(t_welfare,x0,args=(DIJ,Thetaij,th),bounds=bnds,constraints=cons1)
            nijs=vecmat_rwise(eff0.x[0:N*(N-1)],N)
            # Matching the census strategy to ensure that N opt is an integer between zero and five
            nijs1=np.minimum(np.floor(nijs),5*np.ones((N,N)))
            # First-best social capital S opt using N opt
            sopt=scipy.optimize.least_squares(augsc,2*np.ones(N),args=(nijs1,alpha,N),bounds=(np.ones(N),10*np.ones(N)))
            # N obs and N opt (only for friends pairs)
            Nstats_obs[h-1,r-1]=np.sum(np.sum(A*F))/np.sum(np.sum(F))
            Nstats_opt[h-1,r-1]=np.sum(np.sum(nijs1*F))/np.sum(np.sum(F))   
            # S obs and S opt (indiviual level)
            saug=sres00.x
            Sstats_obs[h-1,r-1]=np.sum(saug)/N
            ss1=sopt.x # S opt after imposing the census strategy
            ss2=eff0.x[N*(N-1):N*(N-1)+N] # S opt before imposing the census strategy
            Sstats_opt[h-1,r-1]=np.sum(ss1)/N
            # Store results
            N0r.append(A)
            NIJr.append(nijs)
            NIJ1r.append(nijs1)
            S0r.append(saug)
            S1r.append(ss1)
            S2r.append(ss2)
        N0.append(N0r)
        NIJ.append(NIJr)
        NIJ1.append(NIJ1r)
        S0.append(S0r)
        S1.append(S1r)
        S2.append(S2r)

    Results=[Nstats_obs,Nstats_opt,Sstats_obs,Sstats_opt]
    Results_LIST=[NIJ,NIJ1,N0,S1,S2,S0]
    with open('OPT_OBS_RESULT_Stats.pkl','wb') as f:
        pickle.dump(Results,f)
    with open('OPT_OBS_RESULT_LIST.pkl','wb') as f:
        pickle.dump(Results_LIST,f)
    TB=np.zeros((4,5))
    # Calculate statistics to construct a table
    TB[0,0]=np.mean(np.mean(Nstats_opt[:,0],axis=0))  
    TB[0,1]=np.mean(np.mean(Nstats_obs[:,0],axis=0)) 
    TB[0,2]=np.mean(np.mean(Nstats_opt[:,0]-Nstats_obs[:,0],axis=0))  
    TB[1,0]=np.std(np.mean(Nstats_opt,axis=0)) 
    TB[1,2]=np.std(np.mean(Nstats_opt-Nstats_obs,axis=0)) 
    TB[0,3]=np.min(np.mean(Nstats_opt-Nstats_obs,axis=0)) 
    TB[0,4]=np.max(np.mean(Nstats_opt-Nstats_obs,axis=0)) 
    TB[1,3]=np.quantile(np.mean(Nstats_opt-Nstats_obs,axis=0),0.05) 
    TB[1,4]=np.quantile(np.mean(Nstats_opt-Nstats_obs,axis=0),0.95) 
    TB[0,0]=np.mean(np.mean(Sstats_opt[:,0],axis=0))  
    TB[0,1]=np.mean(np.mean(Sstats_obs[:,0],axis=0)) 
    TB[0,2]=np.mean(np.mean(Sstats_opt[:,0]-Sstats_obs[:,0],axis=0)) 
    TB[1,0]=np.std(np.mean(Sstats_opt,axis=0)) 
    TB[1,2]=np.std(np.mean(Sstats_opt-Sstats_obs,axis=0)) 
    TB[0,3]=np.min(np.mean(Sstats_opt-Sstats_obs,axis=0)) 
    TB[0,4]=np.max(np.mean(Sstats_opt-Sstats_obs,axis=0)) 
    TB[1,3]=np.quantile(np.mean(Sstats_opt-Sstats_obs,axis=0),0.05) 
    TB[1,4]=np.quantile(np.mean(Sstats_opt-Sstats_obs,axis=0),0.95) 
    with open('OPT_OBS_RESULT_Table.pkl','wb') as f:
        pickle.dump(TB,f)